package gui.menus.edit;

import gui.GenericLoader;
import gui.MainFrame;
import service.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import java.io.*;
import java.util.*;

/**
 * @author Andrea
 *
 */
public class AvailableServiceAdder extends JMenuItem
{
	static final long serialVersionUID = 1l;
	
	public AvailableServiceAdder()
	{
		super();
		initialize();
	}
	
	private void initialize()
	{
		this.setText("Set Available Services...");
		this.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				if(GenericLoader.orchestratorIsStarted()){
					JOptionPane.showMessageDialog(MainFrame.getInstance(), "Must stop the orchestrator to add new available services", "Action not allowed",JOptionPane.WARNING_MESSAGE);
					return;
				}

				JFileChooser jfc = new JFileChooser();
				FileInputStream in;
				try {
					Properties applicationProps=new Properties();
					in = new FileInputStream("symphony.conf");
					applicationProps.load(in);
					jfc=new JFileChooser(applicationProps.getProperty("availableDirectory"));
					System.out.println(applicationProps);
					in.close();
				} catch (Exception e1) {
					
				}

				jfc.setFileSelectionMode(JFileChooser.FILES_ONLY);
				jfc.setMultiSelectionEnabled(true);
				
				int returnVal = jfc.showDialog(MainFrame.getInstance(), "Add Available Services");
				
				if(returnVal == JFileChooser.APPROVE_OPTION)
				{
					File[] files = jfc.getSelectedFiles();
					if(files.length>0){
						File firstFile=files[0];
						String pathTargetDirectory=firstFile.getParent();
						try {
							Properties applicationProps=new Properties();

							in = new FileInputStream("symphony.conf");
							applicationProps.load(in);
							in.close();

							applicationProps.setProperty("availableDirectory", pathTargetDirectory);
	
							FileOutputStream out;
							try {
								out = new FileOutputStream("symphony.conf");
								applicationProps.store(out, "");
								out.close();
							} catch (FileNotFoundException e1) {
								e1.printStackTrace();
							} catch (IOException e2) {
								e2.printStackTrace();
							}			

						} catch (Exception e1) {
							
						}
					}
					
					ServiceFactory sf = new ServiceFactoryImpl();
					Vector<TransitionSystem<SimpleState, SimpleTransition>> tss = new Vector<TransitionSystem<SimpleState, SimpleTransition>>(0,1);
					Vector<String> tssNames = new Vector<String>(0, 1);
					Vector<String> pathAvailableServices = new Vector<String>();
					for(int i = 0; i < files.length; i++)
					{
						try
						{
							if(files[i].isDirectory())
							{
								JOptionPane.showMessageDialog(null,"File: << "+ files[i].getName()+" >> is a directory. It will not be used to generate available services" , "Info" , JOptionPane.INFORMATION_MESSAGE);
							}
							else
							{
								tss.addElement(sf.createSimpleTransitionSystem(files[i].getAbsolutePath()));
								tssNames.addElement(files[i].getName());
								pathAvailableServices.addElement(files[i].getAbsolutePath());
							}
						}
						catch(Exception exception)
						{
							JOptionPane.showMessageDialog(null,files[i].getName() + "not loaded: "+exception.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
							System.out.println(exception.getMessage());
						}
					}
					
					GenericLoader.addAvailableServices(tss);
					GenericLoader.addAvailableServicesNames(tssNames);
					GenericLoader.setAvailableServicesPath(pathAvailableServices);
					//populating the JTable with available services
					JTable serviceList=MainFrame.getInstance().getAvServPanel().getAvailableServiceList();
					String data[][]=new String[GenericLoader.getAvailableServicesNames().size()][3];
					Vector<String> availableServicesNames=GenericLoader.getAvailableServicesNames();
					
					Vector<TransitionSystem<SimpleState,SimpleTransition>> availableServices=GenericLoader.getAvailableServices();
					for(int i=0;i<data.length;i++){
						data[i][0]=availableServices.elementAt(i).getName();
						data[i][1]="none";
						data[i][2]=availableServicesNames.elementAt(i);
						
					}			
					TableModel tableModel = 
						new DefaultTableModel(
								data,
								new String[] { "TS name", "State","Filename"});
					serviceList.setModel(tableModel);
					serviceList.getColumnModel().getColumn(0).setPreferredWidth(150);
					serviceList.getColumnModel().getColumn(1).setPreferredWidth(150);
					serviceList.getColumnModel().getColumn(2).setPreferredWidth(150);
					//
					
					JOptionPane.showMessageDialog(MainFrame.getInstance(), tss.size() +" transition system loaded");
					MainFrame.getInstance().getAvServPanel().getActionButton().setEnabled(true);
					MainFrame.getInstance().getAvServPanel().getRemoveAvailableServiceButton().setEnabled(true);
			
				}
			}
		});
	}
	
}
